<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Decode
 */

get_header();
?>

	<section id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) :
		
		$obj = get_queried_object();
		?>

			<header class="page-header">
				<h1 class="page-title">
					<?php
						if ( is_category() ) :
							_e( 'Category', 'ainia' );echo " : ";
							single_cat_title();

						elseif ( is_tag() ) :
							_e( 'Tag', 'ainia' );echo " : ";
							single_tag_title();

						elseif ( is_day() ) :
							printf( __( 'Day: %s', 'ainia' ), '<span>' . get_the_date() . '</span>' );

						elseif ( is_month() ) :
							printf( __( 'Month: %s', 'ainia' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );

						elseif ( is_year() ) :
							printf( __( 'Year: %s', 'ainia' ), '<span>' . get_the_date( 'Y' ) . '</span>' );

						elseif ( is_tax( 'fuente') ) :
							_e( 'Source', 'ainia' );echo " : ";
							echo $obj->name;						
						elseif ( is_tax( 'proyecto') ) :
							_e( 'Project', 'ainia' );echo " : ";
							echo $obj->name;						
						else: 
							_e( 'Archives', 'ainia' );
							echo " : ".$obj->name;	
						endif;
					?>
				</h1>
				<?php
					// Show an optional term description.					
					$term_description = term_description();
					if ( ! empty( $term_description ) ) :
						printf( '<div class="taxonomy-description">%s</div>', $term_description );
					endif;
					global $term;					
					taxonomy_graph($obj->term_id);
				?>
			</header><!-- .page-header -->

			<?php $user_categories = get_user_categories(get_current_user_id()); $alguna=false;?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php
					if( is_post_in_user_categories(get_the_ID())){
					 get_template_part( 'content', get_post_format() );
					 $alguna=true;
					 }
				?>

			<?php endwhile; ?>

			<?php if(false && $alguna)decode_content_nav( 'nav-below' ); ?>

		<?php else : ?>

			<?php get_template_part( 'no-results', 'archive' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</section><!-- #primary -->

<?php get_footer(); ?>